/* dsrl2_get_cru.c
   This method returns the CRU value for the given TI formatted path.
   change log:
   05/24/2025 initial version
   07/05/2025 dylib adjustments
*/ 

#include <dsrl2_private.h>
#include <string.h>
#include <cache_private.h>
#include <dylib.h>

unsigned int dsrl2_get_cru (const char *ti_path) {

   const int len    = dylib.strchr (ti_path, '.') - ti_path;
   unsigned int cru = 0;

   for (int i = 0; i < cache.dsr_list.count; i++) {
      if (strncmp (cache.dsr_list.dsr[i].name, ti_path, len) == 0) {
         cru = cache.dsr_list.dsr[i].cru;
         break;
      }
   }

   return cru;
}
