/* dsrl2_get_device.c
   This method returns the device ID for the given DSR path.
   change log:
   05/24/2025 initial version
   05/29/2025 added TIPI
   05/30/2025 modified search to use strncmp rather than strstr
   07/05/2025 dylib adjustments
*/ 

#include <dsrl2_private.h>
#include <string.h>
#include <dylib.h>

unsigned char dsrl2_get_device (const char * ti_path) {
   unsigned char r = 0;
   if (!strncmp (ti_path, "TIPI", 4)) {
      r = 0x10;
   } else if (!strncmp (ti_path, "DSK", 3)) {
      r = 0x10;
   } else if (!strncmp (ti_path, "WDS", 3)) {
      r = 0x20;
   } else if (!strncmp (ti_path, "SCS", 3)) {
      r = 0x20;
   } else if (!strncmp (ti_path, "IDE", 3)) {
      r = 0x80;
   } else if (!strncmp (ti_path, "HDX", 3)) {
      r = 0x90;
   }
   return r;
}
