/* dsrl2_get_error_description.c
   This method converts an error code to a message.
   change history
   05/24/2025 initial version
*/

#include <dsrl2_private.h>
#include <string.h>
#include <dylib.h>
char *dsrl2_get_error_description (unsigned char error) {
   static char msg[32];
   switch (error) {
      case 0x00:
         dylib.strcpy (msg, "no error");
         break;
      case 0x20:
         dylib.strcpy (msg, "device is write protected");
         break;
      case 0x40:
         dylib.strcpy (msg, "bad open attribute");
         break;
      case 0x60:
         dylib.strcpy (msg, "illegal operation");
         break;
      case 0x80:
         dylib.strcpy (msg, "out of buffer space");
         break;
      case 0xa0:
         dylib.strcpy (msg, "read past end of file");
         break;
      case 0xc0:
         dylib.strcpy (msg, "device error");
         break;
      case 0xe0:
         dylib.strcpy (msg, "file error");
         break;
      default:
         dylib.strcpy (msg, "undefined");
         break;
   }
   return msg;
}
