/* dsr_get_op_addr_link.c
   This method returns the addr and link for a given cru, device and opcode.
   change log:
   05/24/2025 initial version
   05/29/2025 updated error code to 3
*/ 

#include <dsrl2_private.h>
#include <stdio_private.h>

int dsrl2_get_op_addr_link (unsigned int cru, unsigned char device, char opcode, unsigned int *addr, unsigned int *link) {

   int r = 3;

   enable_rom (cru);

   struct DeviceRomHeader* dsrrom = (struct DeviceRomHeader*) 0x4000;
   struct NameLink* entry = (struct NameLink*) dsrrom->basiclnk;

   unsigned int searchname = dsrl2_get_final_method (opcode, device); // 0x0100 | opcode;

   while (entry != 0) {           
      unsigned int entryname = *((unsigned int*)entry->name);

      if (entryname == searchname) {
         *addr = entry->routine;
         *link = (unsigned int) entry;
   
         r = 0;
      
         break; 
      }  
      entry = entry->next;
   }     

   disable_rom (cru);

   return r;
}
