/* dsrl2_get_unit.c
   This method returns the unit for a DSR.
   change log:
   05/24/2025 initial version
   05/29/2025 updated to handle a full ti path
   07/05/2025 dylib adjustments
*/ 

#include <dsrl2_private.h>
#include <string.h>
#include <dylib.h>

unsigned char dsrl2_get_unit (const char *ti_path) {
   unsigned char unit;

   if (!strncmp (ti_path, "TIPI", 4)) {
      unit = 0;
   } else {
      unit = ti_path[3] - '0';
   }

   unit = unit | 0x80;

   return unit;
}
