/* dsrl2_rename_file.c
   This method calls the DSR level 2 rename file method.
   change log:
   05/24/2025 initial version
*/ 

#include <dsrl2_private.h>
#include <stdio.h>
#include <string.h>
#include <dylib.h>

int dsrl2_rename_file (const char *path_src, const char *path_tgt) {

   unsigned int cru;
   unsigned char device;          
   unsigned char unit;            
   char dirname_src[FILENAME_MAX + 2];
   char dirname_tgt[FILENAME_MAX + 2];
   char basename_src[12];
   char basename_tgt[12];
   int r, r_src, r_tgt;
      
   unsigned int addr; 
   unsigned int link;
      
   r_src = dsrl2_collect_info (path_src, &cru, &device, &unit, dirname_src, basename_src);
   r_tgt = dsrl2_collect_info (path_tgt, &cru, &device, &unit, dirname_tgt, basename_tgt);
   r = r_src + r_tgt + dylib.strcmp (dirname_src, dirname_tgt);
         
   if (!r) {
      
      // set directory
         
      // get the addr and link
      r = dsrl2_get_op_addr_link (cru, device, DSRL2_OP_SETDIR, &addr, &link);
         
      // if successful call the method by address
      if (!r) { 
         
         // call the method
         DSRL2_SCRATCH_UNIT     = unit;
         DSRL2_SCRATCH_PATHNAME = (unsigned int) &dirname_src;
         dsrl2_call_method (cru, addr, link);
         r = DSRL2_SCRATCH_ERROR;

         // if the set directory operation was successful, then attempt the mkdir operation
         if (!r) {

            // get the addr and link
            r = dsrl2_get_op_addr_link (cru, device, DSRL2_OP_RENAME_FILE, &addr, &link);

            // if sucessful call the method by address
            if (!r) {

               // call the method
               DSRL2_SCRATCH_UNIT      = unit;
               DSRL2_SCRATCH_FILE_OLD  = (unsigned int) &basename_src;
               DSRL2_SCRATCH_FILE_NEW  = (unsigned int) &basename_tgt;
               dsrl2_call_method (cru, addr, link);
               r = DSRL2_SCRATCH_ERROR;
            }
         }
      }
   }

   return r;
}
