/* dsrl2_rmdir.c
   This method performs a DSR level 2 remove directory call.
   change history
   05/24/2025 initial version
*/ 

#include <dsrl2_private.h>
#include <stdio.h>

int dsrl2_rmdir (const char *path) {

   unsigned int cru;
   unsigned char device;
   unsigned char unit;
   char dirname[FILENAME_MAX + 2];
   char basename[12];
   int r;

   unsigned int addr;
   unsigned int link;

   r = dsrl2_collect_info (path, &cru, &device, &unit, dirname, basename);
   if (!r) {

      // set directory

      // get the addr and link
      r = dsrl2_get_op_addr_link (cru, device, DSRL2_OP_SETDIR, &addr, &link);

      // if successful call the method by address
      if (!r) {

         // call the method
         DSRL2_SCRATCH_UNIT     = unit;
         DSRL2_SCRATCH_PATHNAME = (unsigned int) &dirname;
         dsrl2_call_method (cru, addr, link);
         r = DSRL2_SCRATCH_ERROR;

         // if the set directory operation was successful, then attempt the mkdir operation
         if (!r) {

            // get the addr and link
            r = dsrl2_get_op_addr_link (cru, device, DSRL2_OP_RMDIR, &addr, &link);

            // if sucessful call the method by address
            if (!r) {

               // call the method
               DSRL2_SCRATCH_UNIT  = unit;
               DSRL2_SCRATCH_DIR   = (unsigned int) &basename;
               dsrl2_call_method (cru, addr, link);
               r = DSRL2_SCRATCH_ERROR;
            }
         }
      }
   }

   return r;
}
