/* execv.c
   This method executes a file. Only EA5 programs are supported.
   change log:
   06/01/2023 initial version
   07/23/2023 added test for DSR status, which will confirm that the file is a program type (EA5).
   07/27/2023 added command aliasing support
   09/02/2023 modified to use plugin for get_rom_start_addr
   09/08/2023 updated references to the UNIX99 INITD ROM
   11/01/2023 added common reference SYSTEM_OS_SHORT_NAME
   11/02/2023 updated for system_private.h name changes
   11/16/2023 modified to use cached rom addr
              removed dead code
   02/11/2024 updated to test dsr status for an internal file
   02/12/2024 updated to call file_is_executable rather than file_get_dsr_status
   02/24/2024 broad changes for cache and dylib
   03/06/2024 modified to call exit() after adding the program
   06/16/2025 updated exit reference
*/

#include <stdio.h>
#include <stdio_private.h>
#include <unistd.h>
#include <unistd_private.h>
#include <system_private.h>
#include <constants.h>
#include <cache_private.h>
#include <stdlib.h>
#include <dylib.h>

int execv (const char *path, const char *argv[]) {

   int r = -1;

   char *final_path = (char *) get_unaliased_cmd (path);         // unalias the command
   if (!final_path) {                                
      final_path = (char *) path;                                // if the command wasn't an alias then add it directly
   }

   // confirm dsr_status is defined and that the command path is a program type
   if (file_is_executable (final_path)) {
      int argc = 0;                                              // initialize the arg count
      char *args[16];                                            // set up the args
      args[0] = final_path;                                      // set the command
      while (argv[argc]) {                                       // loop through all the input args
         args[argc + 1] = (char *) argv[argc];                   // copy each arg pointer
         argc++;                                                 // increment the arg count
      }
      args[argc + 1] = NULL;                                     // null terminate the args
      argc++;                                                    // increment argc

      proc_add (NULL, NULL, NULL, argc, (const char **) args);   // add the command to the process queue
      exit (0);

      r = 0;                                                     // set the return value (never reached)
   }

   return r;                                                     // return the result (never reached on success)
}
