/* file_atexit.c
   This method handles closing of the standard files
   change log:
   02/24/2024 added header
              broad changes for dylib
   12/27/2024 rewrote to close all open files rather than the standard files
*/

#include <stdio.h>
#include <cache_private.h>

void file_atexit (void) {
   for (int i = 0; i < FILE_ALL_MAX; i++) {
      if (cache.file_info.file[i].in_use) {
         fclose (&cache.file_info.file[i]);
      }
   }
}
