/* file_clone.c
   This method clones a file.
   change history
   06/02/2025 initial version
   06/15/2025 removed error messages
*/

#include <utility_private.h>
#include <dylib.h>
#include <stdio_private.h>

int file_clone (const char *path_source, const char *path_target, int file_type) {
   int r = 0;

   // read and write modes by TI file_type. Blank strings are for types currently unsupported
   const char *read_mode[]  = {"", "", "r", "rb", "", ""};
   const char *write_mode[] = {"", "", "w", "wb", "", ""};

   // open the source
   FILE *f_source = dylib.fopen (path_source, read_mode[file_type]);
   if (f_source) {

      // open the target
      FILE *f_target = dylib.fopen (path_target, write_mode[file_type]);
      if (f_target) {

         // transfer the file contents from source to target
         if (file_type == 3) {
            file_set_handle_executable (f_target, file_handle_is_executable (f_source));
            unsigned char s[255];
            int n, m;
            while ((n = dylib.fread (s, 1, sizeof (s), f_source))) {
               m  = dylib.fwrite (s, 1, n, f_target);
               r += m != n;
            }
         } else {
            char s[255];
            while (dylib.fgets (s, sizeof (s), f_source)) {
               dylib.fputs (s, f_target);
            }
         }

         // close the target
         dylib.fclose (f_target);
      } else {                  // cannot open target file
         r = 1;
      }

      // close the source
      dylib.fclose (f_source);
   } else {                     // cannot open source file
      r = 1;
   }

   return r;
}
