/* file_get_available.c
   This method returns a free file handle. Note that not all file handles are created equally. A small number support
   DSR and the remainder support console and PIO. Also note that the method doesn't mark the file handle as in-use; that
   is performed by the using method when a file stream has been established.
   change log:
   06/23/2023 initial version
   11/23/2023 updated to use separate dsr
   02/18/2024 updated to use cache-based file_info and dsr_info
*/

#include <stdio_private.h>
#include <cache_private.h>

// get an available file
FILE *file_get_available (bool is_dsr_file) {
   FILE *f = NULL;
   int i;

   // locate a file not currently in use
   for (i = 0; i < FILE_ALL_MAX; i++) {
      if (!cache.file_info.file[i].in_use) {
         // found one, capture the file
         f      = &cache.file_info.file[i];
         f->dsr = NULL;
         break;
      }
   }

   // add dsr data to this file if requested, and a free file was found above
   if (f && is_dsr_file) {
      // locate a free dsr info block
      for (i = 0; i < FILE_DSR_MAX; i++) {
         if (!cache.dsr_info.dsr[i].in_use) {
            // found one, assign it
            f->dsr = &cache.dsr_info.dsr[i];
            break;
         }
      }
      // ensure the dsr was added, if not then cannot open a file
      if (!f->dsr) {
         f = NULL;
      }
   }

   // return the result
   return f;
}
