/* file_has_valid_dsr_name.c
   This method returns the DSR's CRU. If the DSR is invalid, the return is 0.
   change log:
   06/23/2023 initial version
   12/10/2023 updated to use FILENAME_MAX for dsr name length
              removed reference to string_ext.h
   02/18/2024 updated to use cache-based dsr list
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   10/13/2025 changed name from file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <string.h>
#include <stdio.h>
#include <stdio_private.h>
#include <cache_private.h>

int file_get_dsr_cru (const char *name) {

   char dsrname[FILENAME_MAX];
   strcpy (dsrname, name);                                  // copy the dsr path
   strtok (dsrname, ".");                                   // truncate to just the dsr name
  
   int cru = 0;                                             // set the return to 0, which also means no CRU found

   // search through the dsr list looking for a match
   for (int i = 0; i < cache.dsr_list.count; i++) {
      if (!strcmp (dsrname, cache.dsr_list.dsr[i].name)) {  // locate the DSR
         cru = cache.dsr_list.dsr[i].cru;                   // found, capture CRU
         break;                                             // exit loop
      }
   }

   return cru;                                              // return the CRU
}
