/* file_has_full_dsr_path.c
   This method determines if a unix filename has the full dsr path.
   change log:
   05/03/2025 initial version
*/

#include <string.h>
#include <stdio.h>
#include <stdio_private.h>
#include <cache_private.h>

bool file_has_full_dsr_path (const char *name) {

   bool r = false;                          // return flag

   char *p = (char *) name;                 // pointer to the name string next position
   char first_path_element[FILENAME_MAX];   // first path element in the name
   char *q = first_path_element;            // pointer to the first path element next position

   int i;                                   // index

   if (*p == '/') {                         // confirm first element is a forward slash
      p++;                                  // move to the next position
      while (*p && *p != '/') {             // copy the first path element
         *q = *p;                           // copy one byte
         p++;                               // increment pointer in the name
         q++;                               // increment pointer in the first path element
      }
      *q = 0x00;                            // null terminate the first path element

      // search through the dsr list looking for a match with the first path element
      for (i = 0; i < cache.dsr_list.count; i++) {
         if (!strcmp (first_path_element, cache.dsr_list.dsr[i].name)) {
            r = true;
            break;
         }
      }
   }

   return r;
}
