/* file_init.c
   This method initializes file handling.
   change log:
   06/23/2023 initial version
   09/24/2023 added handling of redirect-append
   09/24/2023 corrected file_init method parameters that didn't match the prototype
   10/21/2023 removed use of memory library
   11/23/2023 split out dsr info
   12/10/2023 removed reference to string_ext.h
   02/18/2024 updated to use cache-based data
   12/27/2024 modified to add file_atexit to the atexit list
   01/02/2025 removed call to files() as three is the default number of files on a 
              TI-99/4a and we don't need to waste precious ROM-based code space.
   01/17/2025 removed atexit() call
*/

#include <files.h>
#include <constants.h>
#include <stdio.h>
#include <stdio_private.h>
#include <stdlib.h>
#include <console.h>
#include <string.h>
#include <cache_private.h>

// initializes the dsr info
void dsr_info_init () {
   // loop through all the available DSR files, initializing the data
   for (int i = 0; i < FILE_DSR_MAX; i++) {
      cache.dsr_info.dsr[i].vdp_data_buffer_addr = FILE_DATA_VDP_ADDR_FIRST + i * FILE_BUFFER_SIZE;
      cache.dsr_info.dsr[i].vdp_pab_buffer_addr  = FILE_PAB_VDP_ADDR_FIRST + i * (sizeof (struct PAB) + FILE_PAB_NAME_MAX_LEN);
      cache.dsr_info.dsr[i].in_use               = false;
   }
}

// initializes file_info
void file_init () {

/*
   const unsigned int fdc_reserved_start[16] = {
      0x3BE4, 0x39DE, 0x37D8, 0x35D2, 
      0x33CC, 0x31C6, 0x2FC0, 0x2DBA, 
      0x2BB4, 0x29AE, 0x27A8, 0x25A2, 
      0x239C, 0x2196, 0x1F90, 0x1D8A};
*/

// files (FILE_DSR_MAX);

   // loop through all the files
   for (int i = 0; i < FILE_ALL_MAX; i++) {
      cache.file_info.file[i].fd     = i;
      cache.file_info.file[i].ftype  = UNDEFINED;
      cache.file_info.file[i].dsr    = NULL;
      cache.file_info.file[i].in_use = false;
   }

   // initialize the dsr info
   dsr_info_init ();

   // add closing of files to program exit
// atexit (file_atexit);
}
