/* file_init_pab.c
   This method initializes a pab for DSR access.
   change log:
   06/23/2023 initial version
   11/23/2023 updated to use separate dsr
*/

#include <stdio_private.h>
#include <string.h>

void file_init_pab (FILE *f) {
   f->dsr->pab.VDPBuffer     = f->dsr->vdp_data_buffer_addr;
   f->dsr->pab.OpCode        = 0x00;
   f->dsr->pab.Status        = 0x00;
   f->dsr->pab.RecordLength  = 0x00;
   f->dsr->pab.CharCount     = 0x00;
   f->dsr->pab.RecordNumber  = 0x0000;
   f->dsr->pab.ScreenOffset  = 0x00;
   f->dsr->pab.NameLength    = 0x00;
   f->dsr->pab.pName         = 0x0000;
}
