/* file_is_executable.c
   This method returns true if the file is for a file that is executable.
   change log:
   02/11/2024 initial version
   03/01/2024 modified to use dylib
*/

#include <stdio_private.h>
#include <dylib.h>

bool file_is_executable (const char *path) {
   bool r = false;

   FILE *f = dylib.fopen (path, "rb");
   if (f) {
      r = file_handle_is_executable (f);
      dylib.fclose (f);
   }

   return r;
}
