/* file_is_valid_path.c
   This method determines if the path specified, when fully constructed into a full path, is valid.
   change history
   06/24/2025 initial version
   07/05/2025 dylib adjustments
   10/13/2025 changed ref from file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <stdio_private.h>
#include <unistd_private.h>
#include <dylib.h>

bool file_is_valid_path (const char *path) {

   // collect the cwd
   char cwd[FILENAME_MAX];
   dylib.getcwd (cwd, sizeof (cwd));

   // generate the full unix path
   bool path_ok;
   char unix_path[FILENAME_MAX];
   dylib.generate_unix_path (cwd, (char *) path, &path_ok, unix_path);

   // check that the full unix path also has a valid dsr
   if (path_ok) {
      char dsr_path[FILENAME_MAX];
      generate_dsr_path (dsr_path, unix_path, false);
      path_ok = file_get_dsr_cru (dsr_path) != 0;          // ultimately it must have a corresponding cru
   }

   // return the result
   return path_ok;
}
