/* kernel_file_open_std_files.c
   change log:
   12/10/2023 added header
   02/24/2024 broad changes for cache and dylib
   02/25/2024 added more extensive use of dylib
   12/27/2024 removed call to addexit
   01/06/2025 updated to test for length on filenames rather than a null pointer
   01/20/2025 removed dylib calls
   01/27/2025 changed name to kernel_file_open_std_files
*/ 

#include <stdlib.h>
#include <console.h>
#include <stdio.h>
#include <stdio_private.h>
#include <string.h>
#include <dylib.h>

void file_open_std_files (const char *stdin_filename, const char *stdout_filename, const char *stderr_filename) {

   if (dylib.strlen (stdin_filename)) {
      stdin = dylib.fopen (stdin_filename, "r");                    // handle as a regular file
   } else {
      stdin = dylib.fopen (CONSOLE_WINDOW_DEFAULT, "r");            // set the default to the console
   }

   if (dylib.strlen (stdout_filename)) {
      char *filename = dylib.strtok ((char *)stdout_filename, " "); // capture the filename
      char *mode     = dylib.strtok (NULL, " ");                    // capture the write or append flag
      stdout         = dylib.fopen (filename, mode);
   } else {
      stdout = dylib.fopen (CONSOLE_WINDOW_DEFAULT, "w");           // set the default to the console
   }

   if (dylib.strlen (stderr_filename)) {
      stderr = dylib.fopen (stderr_filename, "w");                  // handle as a regular file
   } else {
      stderr = dylib.fopen (CONSOLE_WINDOW_DEFAULT, "w");           // set the default to the console
   }
}
