/* file_overwrite_query.c
   This method queries the user for permission to overwrite a file.
   change history
   06/02/2025 initial version
*/

#include <utility_private.h>
#include <dylib.h>

bool file_overwrite_query (const char *path) {
   char s[40];
   dylib.fputs ("overwrite ", stderr);
   dylib.fputs (path, stderr);
   dylib.fputs ("? (y/n [n]) ", stderr);          // prompt to overwrite. note that the use of stderr is intentional, allowing the
                                                  // user to be prompted when f_batch is redirected
   dylib.fgets (s, sizeof (s), stdin);
   return s[0] == 'Y' || s[0] == 'y';
}
