/* file_print_dsr_list.c
   This method prints the DSR list, each with their corresponding CRUs.
   change log:
   06/23/2023 initial version
   12/10/2023 added reference to conversion.h
   02/18/2024 updated to use cache-based dsr_list
   01/02/2025 updated to use dylib.fputs over puts due to a now corrected bug in puts where it didn't output line feeds as it should.
   01/20/2025 updated to use dylib.fputs
   07/26/2025 added output noting dual RS232 cards when found
*/

#include <string.h>
#include <conversion.h>
#include <stdio.h>
#include <stdio_private.h>
#include <cache_private.h>
#include <dylib.h>

void file_print_dsr_list () {
   dylib.fputs ("cru  name\n", stdout);
   for (int i = 0; i < cache.dsr_list.count; i++) {
      dylib.fputs (uint2hex (cache.dsr_list.dsr[i].cru), stdout);
      dylib.fputs (" ", stdout);
      dylib.fputs (cache.dsr_list.dsr[i].name, stdout);
      dylib.fputs ("\n", stdout);
   }
   if (cache.dsr_list.dual_rs232) {
      dylib.fputs ("\nDetected two RS232 cards.\n", stdout);
   }
}
