/* file_write_binary_file_status.c
   This method writes the binary file status block to the beginning of the file, serving both the fopen and fclose methods.
   change log:
   02/07/2024 initial version - integrated common code from fopen and fclose
*/

#include <stdio.h>
#include <stdio_private.h>
#include <vdp.h>

/*
FROM FOPEN:
                  // initialize the vdp buffer and write the state
                  vdpmemset (f->dsr->vdp_data_buffer_addr, 0x00, FILE_BINARY_BLOCK_SIZE);
                  vdpmemcpy (f->dsr->vdp_data_buffer_addr, (unsigned char *) &f->bstate, sizeof (binary_state_t));

                  // write to disk
                  f->dsr->pab.OpCode       = DSR_WRITE;
                  f->dsr->pab.RecordNumber = 0;
                  f->dsr->pab.CharCount    = FILE_BINARY_BLOCK_SIZE;
                  r = dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr);

FROM FCLOSE:
                  vdpmemset (f->dsr->vdp_data_buffer_addr, 0x00, FILE_BINARY_BLOCK_SIZE);
                  vdpmemcpy (f->dsr->vdp_data_buffer_addr, (unsigned char *) &f->bstate, sizeof (binary_state_t));

                  f->dsr->pab.OpCode       = DSR_WRITE;
                  f->dsr->pab.RecordNumber = 0;
                  r += dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr);
*/

int file_write_binary_file_status (FILE *f) {
   int r;

   // initialize the vdp buffer and write the state
   vdpmemset (f->dsr->vdp_data_buffer_addr, 0x00, FILE_BINARY_BLOCK_SIZE);
   vdpmemcpy (f->dsr->vdp_data_buffer_addr, (unsigned char *) &f->bstate, sizeof (binary_state_t));

   // write to disk
   f->dsr->pab.OpCode       = DSR_WRITE;
   f->dsr->pab.RecordNumber = 0;
   f->dsr->pab.CharCount    = FILE_BINARY_BLOCK_SIZE;
   r = dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr);

   return r;
}
