/* ftol.c 
   This method converts from a double to a long.
   change log:
   06/23/2023 initial version
*/

#include <math_private.h>
#include <conversion.h>

// converts a double to a long
long __fixdfdi (double d) {
   int np = d_adj_neg_pos (&d); // capture if neg or pos and adjust the radix and first digit in the mantissa
   char *p = (char *) &d;       // capture a pointer to the double
   int radix = *p - 0x40;       // capture the radix
   p++;                         // advance to the mantissa
   char *pend = p + 6;          // last digit in mantissa
   long rr = 1;
   for (int i = radix; i > 0; i--) rr *= 100;

   long r = 0;                   // initialize the return value
   while ((radix >= 0) && (p <= pend)) {
      r = r + rr * (int)*p;
//    fprintf (stdout, "radix %d, mantissa %d, so far %ld\n", radix, (int)*p, r);
      p++;
      radix--;
      rr /= 100;
   }
   if (np < 0) r = -r;
   return r;
}
