/* fopen.c
   These methods open a file and provide support for DSRs, console windows (including those connected with stdin/out/err), and PIO.
   change log:
   06/23/2023 initial version
   08/14/2023 updated for unix paths
   08/25/2023 removed support for parallel port input. Left code commented out. fgets doesn't support parallel input either
   10/21/2023 removed window references
   11/21/2023 updated to use FILENAME_MAX
   11/22/2023 added setting eof
   11/23/2023 updated to use separate dsr
   12/19/2023 added binary file support
   12/22/2023 updated to test dsr operation results associated with binary files
   02/07/2024 modified to use common method file_write_binary_file_status
   02/16/2024 added write cache handling
   02/24/2024 added spinner
   03/06/2024 moved fopen_pio, fopen_console, and fopen_regular_file to separate files
              updated to use dylib for fopen_console and fopen_pio
   01/20/2025 removed use of dylib
   05/03/2025 updated PIO_FILE to TI_PIO_FILE; capture this value from printer_private.h
   12/12/2025 modified to find printer paths that match a starting pattern to allow for alternative paths
*/

#include <string.h>
#include <stdio.h>
#include <stdio_private.h>
#include <printer_private.h>
#include <console.h>
#include <dylib.h>

// provides a file open method.
FILE *fopen (const char *name, const char *mode) {
   FILE *f; 
   // if a console window, create that, otherwise open a regular file
   if (strcmp (name, CONSOLE_WINDOW_DEFAULT) == 0) {     
      f = fopen_console (mode);            // open this file with the special case of console
   } else if (!strncmp (name, TI_PIO_FILE, strlen (TI_PIO_FILE))) {
      f = dylib.fopen_pio (name, mode);          // open this file with the special case of parallel I/O
   } else {         
      f = fopen_regular_file (name, mode); // this is a regular file, although it can still be redirected I/O
   }
   return f;                               // return the file (or null if something went wrong)
}
