/* fopen_console.c
   This method performs a file open operation on the console.
   change log:
   03/06/2024 migrated from fopen
              modified to use switch instead of strcmp
   01/10/2025 updated to use dylib.file_get_available
   01/20/2025 removed use of dylib
*/ 

#include <stdio.h>
#include <stdio_private.h>

FILE *fopen_console (const char *mode) {
   FILE *f = file_get_available (false);   // get an available file index
   if (f) {
      f->is_binary = false;                // set to text value
      f->eof       = false;                // not at end of file
      switch (mode[0]) {
         case 'r':
            f->ftype  = FTYPE_CONSOLE_IN;  // is console input
            f->in_use = true;              // mark file as in use
            break;
         case 'w':
            f->ftype  = FTYPE_CONSOLE_OUT; // is console output
            f->in_use = true;              // mark file as in use
            break;
         default:
            f         = NULL;              // invalid mode was provided
      }
   }
   return f;
}
