/* fopen_pio.c
   This method performs file open on the parallel port.
   change log:
   03/06/2024 moved from fopen
              modified to use switch statement
   01/10/2025 updated to use dylib.file_get_available
   01/20/2025 removed dylib usage
   12/12/2025 updated to set fd value to allow use of either parallel port
*/ 

#include <stdio.h>
#include <stdio_private.h>
#include <dylib.h>

FILE *fopen_pio (const char *name, const char *mode) {
   FILE *f = dylib.file_get_available (false);       // get an available file index
   if (f) {
      f->is_binary = false;                          // set to text value
      f->eof       = false;                          // not at end of file
      f->fd        = name[dylib.strlen (name) - 1];  // capture the last character
      if (f->fd == '2') {                            // if a 2, then this is the second port
         f->fd = 1;                                  // set the index to 1, the second option
      } else {                                       // this will occur in all other cases of a path that ends in O in the case of /PIO, or 1 if /PIO1 or /PIO/1
         f->fd = 0;                                  // set the index to 0
      }

      switch (mode[0]) {
         case 'r':
            f->ftype  = FTYPE_PARALLEL_IN;   // is parallel input
            f->in_use = true;                // mark file as in use
            break;
         case 'w':
            f->ftype  = FTYPE_PARALLEL_OUT;  // is parallel output
            f->in_use = true;                // mark file as in use
            break;
         default:
            f         = NULL;                // invalid mode was provided
      }
   }
   return f;
}
