/* fprint.c
   This method provides print formatting for a file stream.
   change log:
   06/23/2023 initial version
   01/20/2025 updated to use dylib.fputs
*/

#include <stdarg.h>
#include <stdio.h>
#include <stdio_private.h>
#include <dylib.h>

int fprintf (FILE * restrict f, const char *fmt, ...) {
   int r;
   char s[256];
   va_list argp;
   va_start (argp, fmt); 
   r = vsprintf (s, fmt, argp);
   dylib.fputs (s, f);
   va_end (argp);
   return r;
}
