/* fseek.c
   This method seeks the file stream to an offset relative to the whence value
   change log:
   12/20/2023 initial version
*/

#include <constants.h>
#include <stdio.h>
#include <stdio_private.h>

int fseek (FILE *stream, long offset, int whence) {
   int r = UNDEFINED;
   long pos;

   switch (whence) {
      case SEEK_SET:
         pos = offset;
         if (pos >= 0) {
            stream->bstate.pos = pos;
            r                  = 0;
         }
         break;
      case SEEK_CUR:
         pos = stream->bstate.pos + offset;
         if (pos >= 0) {
            stream->bstate.pos = pos;
            r                  = 0;
         }
         break;
      case SEEK_END:
         pos = stream->bstate.len + offset;
         if (pos >= 0) {
            stream->bstate.pos = pos;
            r                  = 0;
         }
         break;
      default:
         break;
   }

   return r;
}
