/* ftoa.c
   This method converts a double to an ascii representation.
   change log:
   06/23/2023 initial version
   03/01/2024 updated to use dylib
*/

#include <string.h>
#include <conversion.h>
#include <dylib.h>

// converts a double to a string
const char *ftoa (double d) {

   static char buffer[40]; // allow for size for - 0 + . + 16 zeros + 14 digits of precision
   char *pb = buffer;
   char *pd = (char *) &d;
   int exp;
   int v[14];
   int neg_pos = 1;
   int i;
   int do_write = 0;
   // collect the exponent
   exp = *pd;
   pd++;

   // collect the first mantissa values
   v[0] = *pd;

   // assess if negative and if so collect the negative value, and update the exp and first mantissa values
   if (v[0] < 0) {
      v[0]    = -v[0];
      exp     = -exp;
      exp--;           // for unclear reasons, negative numbers are also offset by -1
      neg_pos = -1;
   }

   // process the remainder of the first mantissa value
   v[1]  = v[0] % 10;
   v[0] /= 10;
   pd++;

   if ( ( (exp == 0) && (v[0] == 0) && (v[1] == 0) ) || (exp < 0x38) ) { // test for zero or very small number
      dylib.strcpy (buffer, "0.000000000000");
   } else if (exp > 0x48) {
      dylib.strcpy (buffer, "D_TOO_LARGE_D");
   } else {
      exp -= 0x40;

      // collect the remaining mantissa digits
      for (i = 2; i < 14; i+= 2) {
         v[i] = *pd;
         v[i + 1]  = v[i] % 10;
         v[i]     /= 10;
         pd++;
      }

      if (neg_pos == -1) {
         *pb = '-';
         pb++;
      }

      if (exp < 0) {
         *pb = '0';
         pb++;
         *pb = '.';
         pb++;
         do_write = 1;
      }

      int dp = (exp + 1) * 2;
      for (i = dp; i < 0; i++) {
         *pb = '0';
         pb++;
      }

      for (i = 0; i < 14; i++) {
         if ( (i == dp)  && (i != 0) ){
            *pb = '.';
            pb++;
            do_write = 1;
         }
         if ( do_write || (v[i] > 0) ) {
            *pb = '0' + v[i];
            pb++;
            do_write = 1;
         }
      }

      *pb = 0;
   }

   return buffer;
}
