/* generate_dsr_path.c
   This method converts a unix filename into the TI DSR required format.
   change log:
   08/14/2023 initial version
   11/15/2023 added support for a true root directory that maps to a default DSR path
   11/16/2023 removed dead code
   11/21/2023 updated to generate_dsr_path
   12/10/2023 removed reference to string_ext.h
   05/02/2025 added /PI to one of the valid filesystems to support TIPI PI.* special files
              replaced strncmp compare length of hard-coded 5 with strlen of the path element being used
   05/03/2025 replaced test for full path to dsr filesystem with call to file_has_full_dsr_path
   06/23/2025 cleaned up comments, removed dead code
*/

#include <stdbool.h>
#include <string.h>
#include <stdio.h>
#include <stdio_private.h>

void generate_dsr_path (char *dsr_path, char *req_path, bool is_dir) {

   bool have_dsr_path = file_has_full_dsr_path (req_path);

   char *p;

   if (have_dsr_path) {                      // test whether a dsr path was provided
      p = req_path;                          // one was provided, so capture that path
      p++;                                   // advance over the leading forward slash in the path
      strcpy (dsr_path, p);                  // capture the remainder of the path
   } else {
      p = (char *) get_root_fs ();           // don't have a dsr path, so add the default
      p++;                                   // advance over the leading forward slash in the path
      strcpy (dsr_path, p);                  // add the default dsr path
      strcat (dsr_path, req_path);           // append the rest of the requested path
   }

   while (*dsr_path != 0x00) {               // loop through all of dsr_path
      if (*dsr_path == '/') {                // replace slashes with TI's dots
         *dsr_path = '.';
      }
      dsr_path++;                            // move to the next position
   }
   if (is_dir) {                             // ensure directories always end with a dot
      dsr_path--;                            // move backwards one position from the end
      if (*dsr_path != '.') {                // check if the last element is a dot
         dsr_path++;                         // it wasn't, so move back to the end
         strcat (dsr_path, ".");             // append a dot
         *dsr_path = '.';
      }
   }
}
