/* get_day_of_week.c
   Calculates the day of week using Zellers formula for the Gregorian calendar.
   change history
   06/17/2025 initial version
*/

#include <time_private.h>
#include <stdio.h>

int get_day_of_week (int day, int month, int year) {

    month++; // shift month forward by one since the time package uses the range 0..11 for month

    if (month < 3) {
        month += 12;
        year -= 1;
    }
    int k = year % 100;
    int j = year / 100;
    int day_of_week = (day + 13 * (month + 1) / 5 + k + k / 4 + j / 4 + 5 * j) % 7;
 
    day_of_week--; // shift day of week one less into the range 0..6
   
    return day_of_week;
}
