/* get_day_of_year.c
   This method returns the day of the year in the range 0..365.
   change history
   06/17/2025 initial version
*/

#include <time_private.h>
#include <stdbool.h>

bool is_leap_year (int year) {
    return (year % 4 == 0 && year % 100 != 0) || (year % 400 == 0);
}

int get_day_of_year (int day, int month, int year) {
    int days_in_month[] = {31, 28, 31, 30, 31, 30,
                           31, 31, 30, 31, 30, 31};

    if (is_leap_year (year))
        days_in_month[1] = 29;

    int day_count = 0;
    for (int i = 0; i < month; i++)
        day_count += days_in_month[i];

    day_count += day;

    day_count--; // move into the range 0-365

    return day_count;
}
