/* get_rom_start_addr.c
   This method returns the ROM start address.
   change log:
   06/23/2023 initial version
*/

#include <string.h>
#include <rom_private.h>
#include <unistd_private.h>

unsigned int get_rom_start_addr (const char *romprogname) {
   romstdheader_t *rom = (romstdheader_t *) 0x6000;
   romnamelist_t  *proglist;
   char progname[42];
   int len;

   unsigned int r = 0x0000;

   if (rom->flag == 0xAA) {
    
      proglist = rom->proglist;

      while (proglist != 0) {
 
         // add the dsr to the list
         // capture the length - first char of the prog name is the length
         len = (int) proglist->name[0];
         // capture the name - second char is the start of the string
         memcpy (progname, &proglist->name[1], len);
         // null terminate the C string
         progname[len] = 0x00;
         if (strcmp (progname, romprogname) == 0) {
            r = proglist->routine;
            break;
         }
         proglist = (romnamelist_t *) proglist->next;
      }
   }
   return r;
}
