/* get_unaliased_cmd.c
   This method returns the full path to a commmand alias
   change log:
   07/27/2023 moved from shell.c
   08/05/2023 added cd
   08/14/2023 updated for unix paths
   08/15/2023 added rm
   08/18/2023 added cut
   08/18/2023 added clear
   08/18/2023 added uname
   08/18/2023 modified to remove memory constraints
   08/18/2023 added head
   08/18/2023 changed paths to /WDS1/bin
   08/19/2023 changed to lower case program names
   08/20/2023 added tail
   08/24/2023 added color
   09/03/2023 revamped method to use get_root_fs_
   09/22/2023 added hello, pacman
   10/07/2023 removed use of large string array of commands that used a lot of memory
   10/30/2023 added echo
   11/01/2023 added display
   11/03/2023 removed pacman, hello
   11/06/2023 added id
   11/11/2023 added passwd
   11/15/2023 removed use of get_root_fs_
   11/16/2023 removed dead code
   11/21/2023 updated to use FILENAME_MAX
   11/25/2023 added adduser and rmuser
   12/10/2023 removed reference to string_ext.h
   12/11/2023 added sort
   03/01/2024 updated to use dylib
   03/08/2024 added catb
   12/26/2024 added lp
   06/01/2025 added the full list of commands from /bin
   06/12/2025 added diff and hexdump
   07/23/2025 added groff and man
   10/04/2025 added basic and vi
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <unistd_private.h>
#include <stdio_private.h>
#include <dylib.h>

// locate the unaliased command
const char *get_unaliased_cmd (const char *short_cmd) {
   static char final_path[FILENAME_MAX];
   const char *cmds_ld = "adduser basic bye cat catb cd clear color cp cut date df diff display echo exit fontload free grep groff head hexdump id launchd login logout lp ls man mkdir more mv passwd pwd reboot rm rmdir rmuser sh shutdown sort stat tail tee touch uname unix99logo vi wc";

   char cmds[384];
   char *cmd;
   char *long_cmd = NULL;       

   dylib.strcpy (cmds, cmds_ld);
   cmd = dylib.strtok (cmds, " ");
   while (cmd) {
      if (!dylib.strcmp (cmd, short_cmd)) {
         dylib.strcpy (final_path, "/bin/");
         dylib.strcat (final_path, short_cmd);
         long_cmd = final_path;
         break;
      }
      cmd = dylib.strtok (NULL, " ");
   }

   if (!long_cmd) {
      char cwd[FILENAME_MAX];
      dylib.getcwd (cwd, sizeof (cwd));
      bool final_path_ok;
      dylib.generate_unix_path (cwd, (char *) short_cmd, &final_path_ok, final_path);
      if (!final_path_ok) {
         strcpy (final_path, "XXX");
      }
      long_cmd = final_path;
   }

   return long_cmd;
}
