/* gpu_execute.c
   This method executes the requested GPU method.
   change log
   02/08/2025 initial version
   02/11/2025 breakup of gpu.c
*/

#include <gpu_private.h>
#include <cache_private.h>
#include <vdp.h>

int gpu_execute (int method_id) {
   int r = 1;                                    // set to failure initially
   if (cache.gpu_method.gpu_is_present) {        // test for gpu presence
      gpu_execute_unconditionally (method_id);   // call the gpu method
      r = 0;                                     // set to success
   }
   return r;                                     // return the result
}
