/* gpu_execute_unconditionally.c
   This method executes a GPU method without any tests on GPU availability.
   change log
   02/08/2025 initial version
   02/11/2025 breakup of gpu.c
*/

#include <gpu_private.h>
#include <cache_private.h>
#include <vdp.h>

void gpu_execute_unconditionally (int method_id) {
   VDP_SET_REGISTER (0x36, cache.gpu_method.id[method_id].addr[0]);   // VDP GPU PC MSB
   VDP_SET_REGISTER (0x37, cache.gpu_method.id[method_id].addr[1]);   // LSB, sets PC and kicks off GPU execution
   VDP_SET_REGISTER (0x0f, 2);                                        // status register to read = SR2
   while (VDPST & 0x80);                                              // wait for GPU status to be idle
   VDP_SET_REGISTER (0x0f, 0);                                        // status register to read = SR0
}
