/* gpu_init.c
   This set of methods initialize and make available methods executed by the F18A GPU. 
   change log
   02/08/2025 initial version
   02/11/2025 breakup of gpu.c
   02/12/2025 added gpu_f18a_cls and gpu_f18a_scroll
   02/16/2025 moved common gpu methods to console_display_set_mode
   02/18/2025 modified to support placing methods in non-fixed locations
              removed commented out code
              modified to pass in address first and size
*/

#include <gpu_private.h>
#include <cache_private.h>
#include <vdp.h>

__attribute__((noinline)) void gpu_f18a_available (void) {
     __asm__(
        "test_gpu:\n"
        "       li r0,>0101\n"        // value to write if gpu is present
        "       li r1,>2000\n"        // address to which to write
        "       mov r0,*r1\n"         // write it
        "       idle\n"               // idle the GPU
        "       end\n"                // should never be reached
     :::
     "r0","r1","r2"
     );
}

int gpu_init (unsigned int vdp_gpu_method_addr_first, unsigned int vdp_gpu_method_region_size) {

   int r;

   // VDP GPU Methods

   // initialize the method list
   gpu_init_method_list (vdp_gpu_method_addr_first, vdp_gpu_method_region_size);

   // load the first method that tests for gpu existance
   gpu_load_method (GPU_EXISTS, (unsigned char*) gpu_f18a_available, 0x0e);

   // clear the response region which will indicate if the GPU exists. The data in this region will remain initialized / unchanged if the gpu doesn't exist
   unsigned int vdp_data_addr = 0x2000;
   unsigned int vdp_data_size = 2;
   vdpmemset (vdp_data_addr, 0x00, vdp_data_size);

   // call the GPU presence test function
   // note that this method must be attempted unconditionally. the standard gpu_execute will refuse to execute if the gpu
   // hasn't been detected, thus cannot execute this particular test, at least the first time
   gpu_execute_unconditionally (GPU_EXISTS);
 
   // test for presence of the VDP GPU
   unsigned char v[2];
   vdpmemread (vdp_data_addr, v, vdp_data_size);  // v[0] should be non-zero if the GPU executed, with the gpu method writing 0x01 to 0x2000
   cache.gpu_method.gpu_is_present = v[0];        // retain the result

   // finalize
   if (cache.gpu_method.gpu_is_present) {

      r = 0; // return a success (0) response

   } else {

      r = 1; // return a failure (1) response
   }

   return r;
}
