/* gpu_init_method_list.c
   This method initializes the gpu method list.
   change log
   02/08/2025 initial version
   02/11/2025 breakup of gpu.c
   02/18/2025 added region size
*/

#include <gpu_private.h>
#include <cache_private.h>
#include <vdp.h>

void gpu_init_method_list (unsigned int addr, unsigned int region_size) {
   cache.gpu_method.addr_next        = addr;                     // set the first gpu method copy address
   cache.gpu_method.addr_last        = addr + region_size - 1;
   cache.gpu_method.gpu_is_present   = 0;                        // set as gpu not present until we know otherwise
   for (int i = 0; i < 16; i++) {                                // initialize the gpu method addresses
      cache.gpu_method.id[i].addr[0] = 0;
      cache.gpu_method.id[i].addr[1] = 0;
   }
}
