/* gpu_load_method.c
   This method loads a GPU method into VDP RAM.
   change log
   02/08/2025 initial version
   02/11/2025 breakup of gpu.c
   02/18/2025 added test for method fitting in vram
*/

#include <gpu_private.h>
#include <cache_private.h>
#include <vdp.h>

int gpu_load_method (int method_id, unsigned char *cpu_method_addr, int size) {
   int r;
   if (cache.gpu_method.addr_next + size - 1 <= cache.gpu_method.addr_last) {
      cache.gpu_method.id[method_id].addr[0] = cache.gpu_method.addr_next >> 8;       // capture the address msb
      cache.gpu_method.id[method_id].addr[1] = cache.gpu_method.addr_next & 0x00ff;   // capture the address lsb
      vdpmemcpy (cache.gpu_method.addr_next, cpu_method_addr, size);                  // copy the method from cpu ram to vdp ram
      cache.gpu_method.addr_next += size;                                             // increment the next addr based on the method last loaded
      r = 0;
   } else {
      r = 1;
   }
   return r;
}
