/* i2c.c
   This method converts from a hex value to an ascii character representation.
   change log:
   06/23/2023 initial version
*/

#include <conversion.h>

unsigned char i2c (unsigned char i) {
   unsigned char c;
   if ( (i >= 0x00) & (i <= 0x09) ) {
      c = i + '0';
   } else if ( ( i >= 0x0a) & (i <= 0x0f) ) {
      c = i + 'A' - 0x0a;
   } else {
      c = 'f';
   }
   return c;
}
