/* image_clear.c
   This method clears the image at the specified screen coordinates.
   change log:
   11/16/2023 initial version
   01/17/2025 updated to clear images with char id 0x20 rather than 0x00
   01/20/2025 moved console_write_raw to dylib
   01/22/2025 performance improvements
*/

#include <image.h>
#include <image_private.h>
#include <console.h>
#include <dylib.h>

void image_clear (image_t *image, int y, int x) {
   const unsigned char b[] = {0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20};
   for (int i = 0; i < image->height; i++) {
      console_write_raw (y + i, x,  (char *) b, image->width);
   }
}
