/* image_draw.c
   This method draws an image at the specified screen coordinates.
   change log:
   11/16/2023 initial version
   01/20/2025 moved console_write_raw to dylib
   01/22/2025 performance improvements
*/

#include <image.h>
#include <image_private.h>
#include <console.h>
#include <dylib.h>

void image_draw (image_t *image, int y, int x) {
   for (int i = 0; i < image->height; i++) {
      console_write_raw (y + i, x,  (char *) image->id[i], image->width);
   }
}
