/* int2str.c
   This method converts an integer to a string.
   change log:
   06/23/2023 initial version
   12/10/2023 changed reference to string.h
   02/24/2024 broad changes for dylib
   10/13/2025 updated to directly calculate the result rather than relying on uint2str
              reduction in executable sizes by not always having to link in uint2str
              corrected the -32678 cass
*/

#include <conversion.h>
#include <string.h>
#include <dylib.h>

char *int2str (int x) {

   char *out   = dylib.num2str_buf;
   bool unzero = false;
   unsigned int div = 10000;
   unsigned int tmp;
   unsigned int y;

   if (x < 0) {
      y        = -x;
      *(out++) = '-';
   } else {
      y        = x;
   }

   while (div > 0) {
      tmp = y / div;
      y   = y % div;
      if (tmp > 0 || unzero) {
         unzero   = true;
         *(out++) = tmp + '0';
      }
      div /= 10;
   }
   if (!unzero) {
     *(out++) = '0';
   }

   *out = '\0';

   return dylib.num2str_buf;
}
