/* ioctl.c
   This method supports low-level i/o control. For now it supports only
   retrieval of the console window size.
   change log:
   06/23/2023 initial version
   07/26/2023 updated return value to UNDEFINED from -1 (no functional change)
   10/21/2023 removed multiple window references
   10/04/2025 corrected ioctl.h ref
*/

#include <sys/ioctl.h>
#include <stdio.h>
#include <stdio_private.h>
#include <console.h>

int ioctl (int fd, int request, void *v) {

   int r = UNDEFINED;

   FILE *f;
   struct winsize *ws;

   switch (request) {
      case TIOCGWINSZ:
         f = filestream (fd);
         if (f->ftype == FTYPE_CONSOLE_OUT) {
            ws = v;
            console_get_window_size (&ws->ws_row, &ws->ws_col);
            r = 0;
         }
         break;
      default:
         break;
   }

   return r;
}
