/* is_dir.c
   This method returns true if the path is a directory.
   change history
   06/02/2025 initial version
*/

#include <unistd_private.h>
#include <sys/stat.h>

bool is_dir (const char *path) {
   int r;
   struct stat stat_path;
   r = stat (path, &stat_path);             // stat the path. return will be 0 on success (path exists)
   if (!r) {                                // if path exists
      r = S_ISDIR (stat_path.st_mode);      // determine if it's a directory
   } else {
      r = false;                            // doesn't exist, so also not a directory
   }
   return r;                                // return the result
} 
