/* itof.c
   This method converts an integer to a double.
   change log:
   06/23/2023 initial version
*/

#include <conversion.h>

// converts an integer to a double
double itof (int k) {
   int neg_pos = 1;
   int t; 
   if (k < 0) { 
      neg_pos = -1;
      k       = -k;
   }
   double d = uitof (k);
   if (neg_pos == -1) {
      char *w = (char *) &d;
      t = *w;    // capture exponent
      t = t + 1; // increment
      t = -t;    // negate
      *w = t;    // save
      w++;
      t = *w;    // capture first mantissa digit (base 100)
      t = -t;    // negate
      *w = t;    // save
   }
   return d;
}
