/* keyboard_init.c
   This method initializes an external TIPI keyboard.
   change history
   04/16/2025 initial version
   04/21/2025 added test for keyboard availability in keyboard_init
   04/24/2025 updated keyboard.h to private
              added boot notice
   04/30/2025 added unblanking of the display
   05/03/2025 breakout from keyboard.c
   06/02/2025 added test to determine if the keyboard service should be used
   06/14/2025 removed test for config file as usage of an external keyboard is controlled by xkb_drv
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   07/05/2025 dylib adjustments
   10/13/2025 changed ref from file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <stdio_private.h>
#include <keyboard_private.h>
#include <tipi_keyboard.h>
#include <vdp.h>
#include <tipi_msg.h>
#include <kvstore_private.h>
#include <string.h>
#include <dylib.h>

int keyboard_init () {
   int r = 1;

   if (file_get_dsr_cru ("TIPI")) {      // verify there's a TIPI -- it'll have a valid cru

      tipiKeyboardAvailable ();
      r = !keyboarddata[0];
   }

   return r;
}
