/* kvstore_get.c
   This method retrieves a value from a kvstore type.
   change history
   06/14/2025 initial version
*/

#include <string.h>
#include <stdio.h>
#include <kvstore_private.h>

const char *kvstore_get (kvstore_t *kvstore, const char *key) {
   char *r = NULL;                                    // set the default return value

   for (int i = 0; i < kvstore->count; i++) {         // loop through all kv pairs
      if (!strcmp (kvstore->keyval[i].key, key)) {    // find the key
         r = kvstore->keyval[i].val;                  // found it, set return to the val
         break;                                       // exit the loop
      }
   }

   return r;                                          // return the result
}

