/* kvstore_put.c
   This method sets the value of an existing or new key to val.
   change history
   06/14/2025 initial version
*/

#include <kvstore_private.h>
#include <string.h>

int kvstore_put (kvstore_t *kvstore, const char *key, const char *val) {

   int r = 1;                                                 // set the default return value

   for (int i = 0; i < kvstore->count; i++) {                 // loop through all existing keys
      if (!strcmp (kvstore->keyval[i].key, key)) {            // find the key
         strcpy (kvstore->keyval[i].val, val);                // set the val
         r = 0;                                               // set the return value
         break;                                               // exit the loop
      }
   }

   if (r && kvstore->count < 10) {                            // if the key wasn't found and there's still room, add it
      strcpy (kvstore->keyval[kvstore->count].key, key);      // copy the key
      strcpy (kvstore->keyval[kvstore->count].val, val);      // copy the val
      kvstore->count++;                                       // increment the count
      r = 0;                                                  // set the return value
   }
    
   return r;                                                  // return the result
}
