/* kvstore_read.c
   This method retrieves key values from a kvstore-written file.
   change history
   06/14/2025 initial version
*/

#include <stdio.h>
#include <string.h>
#include <kvstore_private.h>

int kvstore_read (kvstore_t *kvstore, const char *path) {

   int r = 1;                                          // set the default return value

   FILE *f = fopen (path, "r");                        // attempt to open the file for reading
   if (f) {                                            // if open,
      kvstore->count = 0;                              // initialize the kvstore count

      char s[80];                                      // string to retrieve data from the file
      while (fgets (s, sizeof (s), f)) {               // loop through the file, reading each line
         s[strcspn (s, "\r\n")] = 0x00;                // kill off CR/LF

         if (s[0] != '#') {                            // if not a comment, then process
            strcpy                                     // extract and save the key
               (kvstore->keyval[kvstore->count].key, 
                strtok (s, " \t"));
            strcpy                                     // extract and save the val
               (kvstore->keyval[kvstore->count].val, 
               strtok (NULL, " \t"));
            kvstore->count++;                          // increment the count
         }
      }

      fclose (f);                                      // close the file
      r = 0;                                           // set the return value
   }

   return r;                                           // return the result
}
