/* kvstore_write.c
   This methods writes a kvstore to disk.
   change history
   06/14/2025 initial version
*/

#include <stdio.h>
#include <string.h>
#include <kvstore_private.h>

int kvstore_write (kvstore_t *kvstore, const char *path) {

   int r = 1;                                        // set the default return value

   FILE *f = fopen (path, "w");                      // attempt to open the file for writing
   if (f) {                                          // if open,

      for (int i = 0; i < kvstore->count; i++) {     // loop through all the kev/val pairs in kvstore
         fputs (kvstore->keyval[i].key, f);          // write the key to file
         fputs ("\t", f);                            // write a tab
         fputs (kvstore->keyval[i].val, f);          // write the val
         fputs ("\n", f);                            // write a LF
      }

      fclose (f);                                    // close the file
      r = 0;                                         // set the return value
   }

   return r;                                         // return the result
}
